function [ h, H ] = get_beamforming_filters( r_mic, N, fs, Nt, mode )

omega = 2*pi*(0:Nt-1)/Nt*fs;
c = 343.1;
k = omega / c;
H = zeros(length(omega),N+1);
switch mode
    case 'modal'
        for n = 0 : N
            H(:,n+1) = 1/(4*pi*1i^n)*(1i*(k*r_mic).^2.*getDifSphH(n,2,k*r_mic));
        end
    case 'DAS'
        for n = 0 : N
            H(:,n+1) = 4*pi*(-1i)^(n-1)*(k*r_mic).^2.*getDifSphH(n,2,k*r_mic).*abs(getSphJ(n,k*r_mic)).^2;
      %      H(:,n+1) = getSphJ(n,k*r_mic);
        end
end
H(isnan(H)) = 0;
h = fftshift(ifft(H,[],1,'symmetric'),1);
H = fft(h,[],1);
end

