function [ h, H ] = get_inv_scat_filters( r_mic, N, fs, Nt )

omega = 2*pi*(0:Nt-1)/Nt*fs;
c = 343.1;
k = omega / c;
H = zeros(length(omega),N+1);
for n = 0 : N
   H(:,n+1) = (1i*(k*r_mic).^2.*getDifSphH(n,2,k*r_mic)).*getSphJ(n,k*r_mic);
end
H(isnan(H)) = 0;
h = fftshift(ifft(H,[],1,'symmetric'),1);
H = fft(h,[],1);
end

