function [ h_reg, H_reg ] = get_regularization_filters( N, Nt, fs, fc )

f = (0:Nt-1)/Nt*fs;
nn = [2 3 4 5];

H0=                                          1./(1+(f/fc(1)).^nn(1));
H1=(f/fc(1)).^nn(1)./(1+(f/fc(1)).^nn(1)) .* 1./(1+(f/fc(2)).^nn(2));
H2=(f/fc(2)).^nn(2)./(1+(f/fc(2)).^nn(2)) .* 1./(1+(f/fc(3)).^nn(3));
H3=(f/fc(3)).^nn(3)./(1+(f/fc(3)).^nn(3)) .* 1./(1+(f/fc(4)).^nn(4));
H4=(f/fc(4)).^nn(4)./(1+(f/fc(4)).^nn(4));
Hs=H0+H1+H2+H3+H4;
H0=H0./Hs;
H1=H1./Hs;
H2=H2./Hs;
H3=H3./Hs;
H4=H4./Hs;
H_reg0 = H0+H1+H2+H3+H4;
H_reg1 = H1+H2+H3+H4;
H_reg2 = H2+H3+H4;
H_reg3 = H3+H4;
H_reg4 = H4;

H_reg = [ H_reg0; H_reg1; H_reg2; H_reg3; H_reg4];
H_reg = H_reg(1:N+1,:);
h_reg = ifft(H_reg.',size(H_reg,2),1,'symmetric');
H_reg = fft(h_reg);

end

