%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% inicio.m
%
%       [ponto,rms] = inicio(impulse)
%
%% Acha o inicio do sinal de acordo com as recomendacoes da ISO 3382
% e se desejado, fornece o nivel de ruido antes do inicio do sinal.
% A entrada e a resposta impulsiva do sinal.

function [ponto,rms] = inicio(impulse)

maximo = find(abs(impulse) == max(abs(impulse)));
energia = (impulse/impulse(maximo(1))).^2;

aux = energia(1:maximo(1)-1);
ponto = maximo(1);
if any(aux(round(end/2):end) > 0.001)
    posicao = (find(aux > 0.001));
    ponto = min(posicao(find(posicao > length(aux)/2)));
    aux = energia(1:ponto-1);
end

if nargout == 2
    rms = 10*log10(sum(aux)/length(aux));
end