clear all; clc;

racs=[1 2 3 3 3 3 3 4 5; ...
    6 7 8 9 9 9 10 11 12; ...
    13 14 15 16 17 18 19 20 21; ...
    22 23 24 25 17 26 27 28 29; ...
    30 31 32 33 17 34 35 36 37];

x1=2.7;
x2=3.6;
% DTW pattern illeszts
dpath='C:\HIL\LisztZeneakademia_Nagyterem\Impulse\';
mic='R';
fs=48000; bit=32;
N=fs*3;
NFFT=2048;

%-----------

wx1=x1-floor(x1);
wx2=1-wx1;
wy1=x2-floor(x2);
wy2=1-wy1;

pos1=racs(floor(x2),floor(x1));
pos2=racs(floor(x2),floor(x1)+1);
pos3=racs(floor(x2)+1,floor(x1));
pos4=racs(floor(x2)+1,floor(x1)+1);

file1=dir([dpath,'\*',num2str(pos1),'*',mic,'*c1*.wav']);
file2=dir([dpath,'\*',num2str(pos2),'*',mic,'*c1*.wav']);
file3=dir([dpath,'\*',num2str(pos3),'*',mic,'*c1*.wav']);
file4=dir([dpath,'\*',num2str(pos4),'*',mic,'*c1*.wav']);

IR1=wavread([dpath file1.name]);
IR2=wavread([dpath file2.name]);
IR3=wavread([dpath file3.name]);
IR4=wavread([dpath file4.name]);

IR12=dokt_ir2interp(IR1,IR2,fs,bit,wx1);
IR34=dokt_ir2interp(IR3,IR4,fs,bit,wx1);
IR1234=dokt_ir2interp(IR12,IR34,fs,bit,wy1);

clf; hold all; 
LIM1=1800; LIM2=3600; kicsi=-max(abs(IR1)); nagy=-kicsi;
subplot(3,2,1);
plot(IR1); set(gca,'Xlim',[LIM1 LIM2]); set(gca,'Ylim',[kicsi nagy]);
subplot(3,2,2);
plot(IR2); set(gca,'Xlim',[LIM1 LIM2]); set(gca,'Ylim',[kicsi nagy]);
subplot(3,2,3);
plot(IR3); set(gca,'Xlim',[LIM1 LIM2]); set(gca,'Ylim',[kicsi nagy]);
subplot(3,2,4);
plot(IR4); set(gca,'Xlim',[LIM1 LIM2]); set(gca,'Ylim',[kicsi nagy]);
subplot(3,1,3);
plot(IR1234); set(gca,'Xlim',[LIM1 LIM2]); set(gca,'Ylim',[kicsi nagy]);
hold off; 
