
function varargout = main(varargin)
% MAIN M-file for main.fig
%      MAIN, by itself, creates a new MAIN or raises the existing
%      singleton*.
%
%      H = MAIN returns the handle to a new MAIN or the handle to
%      the existing singleton*.
%
%      MAIN('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MAIN.M with the given input arguments.
%
%      MAIN('Property','Value',...) creates a new MAIN or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before main_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to main_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help main

% Last Modified by GUIDE v2.5 02-Dec-2007 15:16:17

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @main_OpeningFcn, ...
                   'gui_OutputFcn',  @main_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT



% --- Executes just before main is made visible.
function main_OpeningFcn(hObject, eventdata, handles, varargin)


draw_grid_2(handles);
draw_grid_1(handles);
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to main (see VARARGIN)

set(handles.status,'String','Init')


% Choose default command line output for main
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes main wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = main_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on mouse press over axes background.
function axes1_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to axes1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
point = get(handles.axes1,'currentpoint');
felirat =  strcat(num2str(point(1,1)), ', ', num2str(point(1,2)));
set(handles.status,'String', felirat);

% axes('axes1);
cla;

x=[point(1,1)-0.005, point(1,2)-0.005];
y=[point(1,1)+0.005, point(1,2)+0.005];

line([x(1), y(1)],[x(2), y(2)]);
line([y(1), x(1)],[x(2), y(2)]);
%plot(handles.axes1, x, y);

%hold on;

draw_grid_2(handles);
draw_grid_1(handles);

%x=[0,1];
%y=[0,1];
%plot(handles.axes1, x, y);

%hold off;

% --- Drawing the grid on the axes
function draw_grid_2(handles)


racs = [1 2 3 3 3 3 3 4 5; ...
    6 7 8 9 9 9 10 11 12; ...
    13 14 15 16 17 18 19 20 21; ...
    22 23 24 25 17 26 27 28 29; ...
    30 31 32 33 17 34 35 36 37]; 

axes(handles.axes2);
cla;
% the size of the grid
n_x = size(racs, 2);
n_y = size(racs, 1);
n_x = n_x - 1;
n_y = n_y - 1;
for j = 0:1:n_y - 1
    for i = 0:1:n_x - 1
        line([i/n_x, (i+1)/n_x],[j/n_y, j/n_y]);
        line([i/n_x, i/n_x],[j/n_y, (j+1)/n_y]);
    end
end


function draw_grid_1(handles)

racs = [1 2 3 3 3 3 3 4 5; ...
    6 7 8 9 9 9 10 11 12; ...
    13 14 15 16 17 18 19 20 21; ...
    22 23 24 25 17 26 27 28 29; ...
    30 31 32 33 17 34 35 36 37]; 

% a szinpadkoordinatak
l1 = 5;
l2 = 7;
l3 = 6.2;

pos = [.35 8.4; .35 6.3; 1.9 7.15; 2.6 8.4; 1.9 9.7; .35 10.2; .35 4.76; ...
    2 5.5; 3.6 6.7; 4.5 8.4; 3.6 10.2; 2 11.1; .35 11.6; .35 3.37; 2.1 3.4; ...
    3.6 4.76; l1 6.3; l2 8.4; l1 10.7; 3.6 12.2; 2.1 13; .35 13.3; 0.35 1.88; ...
    2 2; 3.8 2.8; 5.8 4.4; 5.8 12.3; 3.8 13.9; 2 14.5; .35 15; 1.5 .5; 3.7 1; ...
    5.8 1.35; l3 2.86; l3 14.2; 5.8 15.6; 3.7 16; 1.5 16.4];

maxx = max(pos(:,1));
maxy = max(pos(:,2));
pos(:,1) = pos(:,1)./maxx;
pos(:,2) = pos(:,2)./maxy;


axes(handles.axes1);
% the points of the rubbergrid
%u = [[.12, .31, .5, .77]; [.23, .41, .5, .62]; [.13, .25, .4, .62]; [.16, .53, .68, .8]; [.11, .3, .47, .68]];
%v = [[.7, .7, .73, .88]; [.64, .63, .63, .69]; [.58, .58, .58, .59]; [.31, .3, .37, .46]; [.15, .04, .15, .1]];

for i = 1:1:size(racs,1)
    for j = 1:1:size(racs,2)
        u(i,j) = pos(racs(i,j) + 1, 1);
        v(i,j) = pos(racs(i,j) + 1, 2);
    end
end

% dimension of the matrix
nm = size(u);
n_u = nm(1);
n_v = nm(2);
% horizontal lines
for i = 1:1:n_u
    for j = 1:1:n_v-1
        line([u(i,j), u(i, j+1)], [v(i,j), v(i, j+1)]);
    end
end
% vertical lines
for i = 1:1:n_u-1
    for j = 1:1:n_v
        line([u(i,j), u(i+1, j)], [v(i,j), v(i+1, j)]);
    end
end
% find the cell of the mouse click
point = get(handles.axes1,'currentpoint');
P = [point(1,1) point(1,2) 0];
cx = -1;
cy = -1;
for i = 1:1:n_u-1
    for j = 1:1:n_v-1
        %test the current cell
        S1 = [u(i,j) v(i, j) 0];
        S2 = [u(i+1,j) v(i+1, j) 0];
        S3 = [u(i+1,j+1) v(i+1, j+1) 0];
        S4 = [u(i,j+1) v(i, j+1) 0];
        
        M1 = cross(P-S4, S1-S4);
        M2 = cross(P-S1, S2-S1);
        M3 = cross(P-S2, S3-S2);
        M4 = cross(P-S3, S4-S3);
        
        if(M1(3) <= 0 && M2(3) <= 0 && M3(3) <= 0 && M4(3) <= 0)
            fprintf(1, 'found cell: %d, %d\n', i, j);
            cx = j; %oszlop
            cy = i; %sor
        end
    end
end

if (cx > 0 && cy > 0)
    S = [[u(cy,cx) v(cy, cx)]; [u(cy+1,cx) v(cy+1, cx)]; [u(cy+1,cx+1) v(cy+1, cx+1)]; [u(cy,cx+1) v(cy, cx+1)]];
    
    if((S(1,1) == S(2,1) && S(1,2) == S(2,2)) || ...
            (S(2,1) == S(3,1) && S(2,2) == S(3,2)) || ...
            (S(3,1) == S(4,1) && S(3,2) == S(4,2)) || ...
            (S(1,1) == S(4,1) && S(1,2) == S(4,2)))
        
        if(S(1,1) == S(4,1) && S(1,2) == S(4,2))
            S1 = [S(2,1) S(2,2)];
            S2 = [S(3,1) S(3,2)];
            S3 = [S(1,1) S(1,2)];
        end
        
        if(S(4,1) == S(3,1) && S(4,2) == S(3,2))
            S1 = [S(1,1) S(1,2)];
            S2 = [S(2,1) S(2,2)];
            S3 = [S(4,1) S(4,2)];
        end
        
        if(S(3,1) == S(2,1) && S(3,2) == S(2,2))
            S1 = [S(4,1) S(4,2)];
            S2 = [S(1,1) S(1,2)];
            S3 = [S(3,1) S(3,2)];
        end
        
        if(S(1,1) == S(2,1) && S(1,2) == S(2,2))
            S1 = [S(3,1) S(3,2)];
            S2 = [S(4,1) S(4,2)];
            S3 = [S(2,1) S(2,2)];
        end
        
        v1 = ( (P(1) - S3(1))*(S2(2) - S3(2)) - (P(2) - S3(2))*(S2(1) - S3(1)) ) / ...
            ( (P(2) - S3(2))*(S1(1) - S2(1)) - (P(1) - S3(1))*(S1(2) - S2(2)) );
        
        v2 = ( P(1) - S3(1) ) / ( v1*S1(1) + (1 - v1)*S2(1) - S3(1) );
        
        if(S(1,1) == S(4,1) && S(1,2) == S(4,2))
            w1=v1;
            w2=1-v2;
        end
        
        if(S(4,1) == S(3,1) && S(4,2) == S(3,2))
            w1=v2;
            w2=v1;
        end
        
        if(S(3,1) == S(2,1) && S(3,2) == S(2,2))
            w1=1-v1;
            w2=v2;
        end
        
        if(S(1,1) == S(2,1) && S(1,2) == S(2,2))
            w1=1-v2;
            w2=1-v1;
        end
        
        
        
    else

        PX = P(1);
        PY = P(2);

        BY1 = S(3,2) - S(2,2);
        CY1 = S(3,2);
        BY2 = S(1,2) - S(2,2) + S(3,2) - S(4,2);
        CY2 = S(4,2) - S(3,2);

        BX1 = S(3,1) - S(2,1);
        CX1 = S(3,1);
        BX2 = S(1,1) - S(2,1) + S(3,1) - S(4,1);
        CX2 = S(4,1) - S(3,1);

        a = BY1*BX2 - BX1*BY2;
        b = BY1*CX2 + BX2*PY - BX2*CY1 - BY2*PX + BY2*CX1 - BX1*CY2;
        c = (PY - CY1)*CX2 - (PX - CX1)*CY2;

        w11 = (-b - sqrt(b*b - 4*a*c)) / (2*a);
        w12 = (-b + sqrt(b*b - 4*a*c)) / (2*a);

        w1 = w11;
        if(w1 < 0 || w1 > 1) 
            w1 = w12;
        end

        w2 = (PX - w1*S(2,1) - (1 - w1)*S(3,1)) / (w1*S(1,1) + (1 - w1)*S(4,1) - w1*S(2,1) - (1 - w1)*S(3,1));

    end
    
    fprintf(1, 'w1 = %d\nw2= %d\n\n', w1, w2);
    
    %drawing the place in the grid
    orig_x = 1/(n_v-1)*(cx - w1);
    orig_y = 1 - 1/(n_u-1)*(cy - w2);

    
    axes(handles.axes2);
    line([orig_x - 0.01, orig_x + 0.01], [orig_y - 0.01, orig_y + 0.01]);
    line([orig_x - 0.01, orig_x + 0.01], [orig_y + 0.01, orig_y - 0.01]);
    
    % innentl processzlunk
    
    % rcspontok
    pos1=racs(floor(cy),floor(cx));
    pos2=racs(floor(cy),floor(cx)+1);
    pos3=racs(floor(cy)+1,floor(cx));
    pos4=racs(floor(cy)+1,floor(cx)+1);
    
    dpath='C:\HIL\LisztZeneakademia_Nagyterem\Impulse\';
    mic='R';
    fs=48000; bit=32;
 
    [IR12,IR23,IR1234]=dokt_ir4interp_v21(dpath,mic,fs,bit,pos1,pos2,pos3,pos4,w1,w2);
    
end

