function lef(FILEBASE)
% Lateral Energy Fractions measurement from B-format impulse responses

in_w=[FILEBASE '_c1_i.wav'];
in_x=[FILEBASE '_c2_i.wav'];
in_y=[FILEBASE '_c3_i.wav'];
in_z=[FILEBASE '_c4_i.wav'];

%constants
    range = [1,20000]; % only beginning of file is needed, 80 ms @ 192kHz = 15360 smpls
    c_sound = 340; % [m/s]
    smpl_predirect = 5; % [smpls]
    t_postdirect = 1; %[ms]
    %smpl_postdirect = 48;
    sc_delay = 65.28; % [smpls]
    
% Reading files
    [W,fs,bit] = wavread(in_w,range); 
    X = wavread(in_x,range);
    Y = wavread(in_y,range);
    Z = wavread(in_z,range);

% calculate integration limits
    t_5ms = fs*0.005;
    t_80ms = fs*0.080;

% find beginning (k)
    edc=dipl_edc(W);

    for k=1:length(edc),
        if edc(k)<=-0.5, % edc -0.5 dB-re szinkronizls
            break;
        end;
    end;
    %plot(edc);

% source distance and direction estimation
    fprintf('\nBeginning of impulse: %g samples, %g ms, %g ms delay compensated',k,k/fs*1000,(k-sc_delay)/fs*1000);
    fprintf('\nEstimated source distance: %g m',c_sound*(k-sc_delay)/fs);
    if k <= smpl_predirect
        smpl_predirect = k - 1;
    end
    smpl_postdirect = t_postdirect/1000 * fs;
    d_range = k-smpl_predirect : k+smpl_postdirect; % range for direct sound
    
    % filtering for angle detection    
        [b,a] = butter(6, [1000/(fs/2),6000/(fs/2)]);
        Wf = filtfilt(b,a,W(d_range));
        Xf = filtfilt(b,a,X(d_range));
        Yf = filtfilt(b,a,Y(d_range));
        Zf = filtfilt(b,a,Z(d_range));
    
    AI_X = mean(sqrt(2)*X(d_range).*W(d_range)); 
    AI_Y = mean(sqrt(2)*Y(d_range).*W(d_range));
    AI_Z = mean(sqrt(2)*Z(d_range).*W(d_range));
    
        
    AIF_X = mean(sqrt(2)*Xf.*Wf); 
    AIF_Y = mean(sqrt(2)*Yf.*Wf);
    AIF_Z = mean(sqrt(2)*Zf.*Wf);
    
    % calculate angles
         [azim,elev,r] = cart2sph(AIF_X,AIF_Y,AIF_Z);
         fprintf('\nFiltered-Estimated azimuth: %g degrees',azim*180/pi);
         fprintf('\nFiltered-Estimated elevation: %g degrees',elev*180/pi);
         compass(Xf.*Wf, Yf.*Wf);
    
%     % find signs using cross correlation coefficient
%     Xrms = sign(corr(W(d_range),X(d_range))) * Xrms;
%     %corr(sqrt(2)*W(d_range),X(d_range))
%     Yrms = sign(corr(W(d_range),Y(d_range))) * Yrms;
%     %corr(sqrt(2)*W(d_range),Y(d_range))
%     Zrms = sign(corr(W(d_range),Z(d_range))) * Zrms;
%     %corr(sqrt(2)*W(d_range),Z(d_range))
    
    % calculate angles
    
    [azim,elev,r] = cart2sph(AI_X,AI_Y,AI_Z);
    fprintf('\nEstimated azimuth: %g degrees',azim*180/pi);
    fprintf('\nEstimated elevation: %g degrees',elev*180/pi);
    
%LF
    LF = sum(Y(k+t_5ms : k+t_80ms).^2) / sum(2*W(k : k+t_80ms).^2);
    fprintf('\nLF: %g',LF);
%LFC
    LFC = sum(sqrt(2)*abs(W(k+t_5ms : k+t_80ms).*Y(k+t_5ms : k+t_80ms))) / sum(2*W(k : k+t_80ms).^2);
    % Ez nem egyezik a Farina fele Aurora adataival egyelore!
    % De mar egyezik, valoszinleg elrontotta a paper-jeben.
    fprintf('\nLFC: %g\n',LFC);


    


