function locgraph(FILEBASE)
% Lateral Energy Fractions measurement from B-format impulse responses

in_w=[FILEBASE '_c1_i.wav'];
in_x=[FILEBASE '_c2_i.wav'];
in_y=[FILEBASE '_c3_i.wav'];
in_z=[FILEBASE '_c4_i.wav'];
% in_w=[FILEBASE '_w.wav'];
% in_x=[FILEBASE '_x.wav'];
% in_y=[FILEBASE '_y.wav'];
% in_z=[FILEBASE '_z.wav'];

%constants
    readrange = [1,20000]; % only beginning of file is needed, 80 ms @ 192kHz = 15360 smpls
    c_sound = 340; % [m/s]
    smpl_predirect = 5; % [smpls]
    t_postdirect = 1; %[ms]
    smpl_pk = 20;
    %smpl_postdirect = 48;
    sc_delay = 65.28; % [smpls]
    
% Reading files
    [W,fs,bit] = wavread(in_w,readrange); 
    X = wavread(in_x,readrange);
    Y = wavread(in_y,readrange);
    Z = wavread(in_z,readrange);

% calculate integration limits
    t_1ms = fs*0.001;
    t_5ms = fs*0.005;
    t_80ms = fs*0.080;

% find beginning (k)
    edc=dipl_edc(W);

    for k=1:length(edc),
        if edc(k)<=-0.1, % edc -0.5 dB-re szinkronizls
            break;
        end;
    end;
    %plot(edc);
    
% location graph    
% 
       [b,a] = butter(6,80/24000, 'high');
        Wf = filtfilt(b,a,W);
        Xf = filtfilt(b,a,X);
        Yf = filtfilt(b,a,Y);
        Zf = filtfilt(b,a,Z);
%           Wf = W; Xf = X; Yf = Y; Zf = Z;

% set range
    range=[1,5000];
%     range = readrange;
    if range(1) < k+1*t_1ms
        range(1) = k+1*t_1ms;
    end
        
    [maxima_u] = peakdetect2(Wf.^2,3.5,-60,range);
    
    % directional reflectogram
    figure;
    plot(linspace(0,length(Wf)./fs,length(Wf)),sqrt(2)*Wf.*Zf);
    xlabel('Id [s]');
    ylabel('rel. ampl.');
    
    % calculate means around detected peaks !!! no check for data begin/end
   
    AI_X = []; AI_Y=[]; AI_Z = [];
    for i=1:length(maxima_u)
        pk_range = maxima_u(i)-smpl_pk : maxima_u(i)+smpl_pk;
    
        AI_X(i) = mean(sqrt(2)*Xf(pk_range).*Wf(pk_range)); 
        AI_Y(i) = mean(sqrt(2)*Yf(pk_range).*Wf(pk_range));
        AI_Z(i) = mean(sqrt(2)*Zf(pk_range).*Wf(pk_range));
 
    end
    
    azim = atan2(AI_Y, AI_X);
    disp(azim*180/pi);
%     AI_X = log10(AI_X);
%     AI_Y = log10(AI_Y);
%     AI_Z = log10(AI_Z);
%      pk_range = range(1):range(2);
% %     
%         AI_X = sqrt(2)*Xf(pk_range).*Wf(pk_range); 
%         AI_Y = sqrt(2)*Yf(pk_range).*Wf(pk_range);
%         AI_Z = sqrt(2)*Zf(pk_range).*Wf(pk_range);

%      S = sqrt(AI_X.^2+AI_Y.^2+AI_Z.^2);
%      norm = 1./S;
%      S = max(norm)*S;
%     figure;
%     %[a,b,c]=sphere(20);
%     %alpha(.2);
%     %mesh(a,b,c);
%     
%     %hidden on; 
%     scatter3(norm.*AI_X,norm.*AI_Y,norm.*AI_Z,10*log10(S),1:length(maxima_u),'filled');
%     %hold off;
%     axis vis3d;
%     xlabel('X');
%     ylabel('Y');
%     zlabel('Z');
%     set(gca,'XTick',[-0.75,0.75],'YTick',[-0.75,0.75],'ZTick',[-0.75,0.75]);
%     set(gca,'XTickLabel',{'htra';'elre'},'YTickLabel',{'jobbra';'balra'},'ZTickLabel',{'le';'fel'});
%     colormap(flipud(jet(128)));
%     tit = sprintf('Korai reflexik: %0.1f - %0.1f ms',range(1)/fs*1000,range(2)/fs*1000);
     fprintf('Korai reflexik: %0.1f - %0.1f     ms',range(1)/fs*1000,range(2)/fs*1000);

%     title(tit);
%    % colormap(gray(128));
% %     caxis
    %figure;
%     h1 = subplot(1,3,1);
    h1 = figure;
    comp(AI_X,AI_Y);
    title('X-Y sk');
    view(-90,90);
%     h2 = subplot(1,3,2);
    h2 = figure;
    comp(AI_X,AI_Z);
    title('X-Z sk');
    view(360,90);
%     h3 = subplot(1,3,3);
    h3 = figure;
    comp(-AI_Y,AI_Z);
    title('Y-Z sk');
    %rotate(h3,[1 0 0],45)
    %view(180,90);
    
     %feather(sc*X(maxima_u).*W(maxima_u),sc*Y(maxima_u).*W(maxima_u));
% source distance and direction estimation
    fprintf('\nBeginning of impulse: %g samples, %g ms, %g ms delay compensated',k,k/fs*1000,(k-sc_delay)/fs*1000);
    fprintf('\nEstimated source distance: %g m',c_sound*(k-sc_delay)/fs);
    if k <= smpl_predirect
        smpl_predirect = k - 1;
    end
    smpl_postdirect = t_postdirect/1000 * fs;
    d_range = k-smpl_predirect : k+smpl_postdirect; % range for direct sound
    
    % filtering for angle detection    
        [b,a] = butter(6, [1000/(fs/2),4000/(fs/2)]);
        Wf = filtfilt(b,a,W(d_range));
        Xf = filtfilt(b,a,X(d_range));
        Yf = filtfilt(b,a,Y(d_range));
        Zf = filtfilt(b,a,Z(d_range));
    
    AI_X = mean(sqrt(2)*X(d_range).*W(d_range)); 
    AI_Y = mean(sqrt(2)*Y(d_range).*W(d_range));
    AI_Z = mean(sqrt(2)*Z(d_range).*W(d_range));
    
        
    AIF_X = mean(sqrt(2)*Xf.*Wf); 
    AIF_Y = mean(sqrt(2)*Yf.*Wf);
    AIF_Z = mean(sqrt(2)*Zf.*Wf);
    
    sc = 1000; %scale because of filtering
%     subplot(h1); hold on; comp(sc*AIF_X,sc*AIF_Y,'r'); hold off;
%     subplot(h2); hold on; comp(sc*AIF_X,sc*AIF_Z,'r'); hold off;
%     subplot(h3); hold on; comp(sc*-AIF_Y,sc*AIF_Z,'r'); hold off;
    figure(h1); hold on; comp(sc*AIF_X,sc*AIF_Y,'r'); hold off;
    figure(h2); hold on; comp(sc*AIF_X,sc*AIF_Z,'r'); hold off;
    figure(h3); hold on; comp(sc*-AIF_Y,sc*AIF_Z,'r'); hold off;
    % calculate angles
         [azim,elev,r] = cart2sph(AIF_X,AIF_Y,AIF_Z);
         fprintf('\nFiltered-Estimated azimuth: %g degrees',azim*180/pi);
         fprintf('\nFiltered-Estimated elevation: %g degrees',elev*180/pi);
%          compass(Xf.*Wf, Yf.*Wf);
      
    [azim,elev,r] = cart2sph(AI_X,AI_Y,AI_Z);
    fprintf('\nEstimated azimuth: %g degrees',azim*180/pi);
    fprintf('\nEstimated elevation: %g degrees',elev*180/pi);
    


