function [R_est,A_est,snr_est,c]=rtxxnonlink(ir,fs,mode,K)
% nemlin. illeszts EDC-re
% ir, fs, mode: lecsengsi tagok szma: 1..3
Lx=length(ir);
Le=length(ir)/fs;
L=1;
t=linspace(0,L,Le*fs);
k=3*log(10);
t_smpl = linspace(0, length(ir)-1, K)/fs;
% 1:10 alulmintavtelezs
tx0=0.1; %0.0002; % minimlis zengsid
switch mode
    
    case 1 % egyszeres illeszts nemlog-os EDC-re
        if Lx ~= K, mit=10.^(nincsnan(edc(ir))./10); mit = nincsnan(interp1(t(1:length(mit)), mit, t_smpl));
        else mit=10.^(nincsnan(edc(ir))./10); end;
        start = [1,   tx0,          10^(-50/10)];
        low   = [0,   0,            0];
        up    = [Inf, 2*k/(tx0*L),  1];
        options = fitoptions('Method','NonlinearLeastSquares','Upper',up,'Lower',low,'StartPoint',start);
        f = fittype('(x1*exp(-x2*x)+x3*(L-x))','problem', 'L');
        c = fit(t_smpl(1:length(mit))',mit',f,options,'problem',L);
        R_est = Le * (2*k) / c.x2;
%         snr_est = 10.*log10(-c.x3.*sum(ir.^2));
        snr_est = -10.*log10(c.x3);
        A_est = c.x1;
        
    case 2 % ketts lecsengs illesztse log-os EDC-re
        if Lx ~= K, mit = nincsnan(edc(ir)); mit = nincsnan(interp1(t(1:length(mit)), mit, t_smpl));
        else mit=nincsnan(edc(ir)); end; 

        start = [0.001, 0.999,  2*k/(tx0*L), 2*k/(tx0*L),  10^(-80/10)];
        low   = [0,     0,      0,           2*k/(10*L),   0];
        up    = [1,     1,      2*k/(tx0*L), 2*k/(tx0*L),  1];
        options = fitoptions('Method','NonlinearLeastSquares','Upper',up,'Lower',low,'StartPoint',start);
        set(options,'Maxiter',200);
        f = fittype('10*log10((1 - (A^2*b^2 + B^2*a^2 - (A^2*b^2)/exp(a*x) - (B^2*a^2)/exp(b*x) + A^2*a*b + B^2*a*b - (A^2*a*b)/exp(a*x) - (B^2*a*b)/exp(b*x) + 4*A*B*a*b - (4*A*B*a*b)/exp((a*x)/2 + (b*x)/2))/(A^2*b^2 + B^2*a^2 - (A^2*b^2)/exp(L*a) - (B^2*a^2)/exp(L*b) + A^2*a*b + B^2*a*b - (A^2*a*b)/exp(L*a) - (B^2*a*b)/exp(L*b) + 4*A*B*a*b - (4*A*B*a*b)/exp((L*a)/2 + (L*b)/2)))+x3*(L-x))','problem', 'L');
        c = fit(t_smpl(1:length(mit))',mit',f,options,'problem', L);
        snr_est= -10.*log10(c.x3); if imag(snr_est)~=0, snr_est = Inf; end;
        A_est=[c.A c.B]./max(abs([c.A c.B]));
        R_est= Le * 2*k./[c.a c.b];
        
    case 3 % hrmas lecsengs illesztse log-os EDC-re
        if Lx ~= K, mit = nincsnan(edc(ir)); mit = nincsnan(interp1(t(1:length(mit)), mit, t_smpl));
        else mit=nincsnan(edc(ir)); end; 
        I0=0.05; I1=0.1; I2=0.25; I3=2;
        start = [0.9, 0.1, 0.05,     2*k/(0.1*L),            2*k/(0.5*L),            2*k/(1*L),    10^(-80/10)];
        low =   [0,     0,    0,     2*k/(mean([I1,I2])*L),  2*k/(mean([I2,I3])*L),  2*k/(I3*L),   0];
        up  =   [1,     1,    1,     2*k/(I0*L),             2*k/(I1*L),             2*k/(I2*L),   1];    
        options = fitoptions('Method','NonlinearLeastSquares','Upper',up,'Lower',low,'StartPoint',start);
        set(options,'Maxiter',200);
        f = fittype('10*log10( ((A^2*b^2*q^3)/exp(2*a*x) - (A^2*b^3*q^2)/exp(2*L*a) - (B^2*a^2*q^3)/exp(2*L*b) - (B^2*a^3*q^2)/exp(2*L*b) - (Q^2*a^2*b^3)/exp(2*L*q) - (Q^2*a^3*b^2)/exp(2*L*q) - (A^2*b^2*q^3)/exp(2*L*a) + (A^2*b^3*q^2)/exp(2*a*x) + (B^2*a^2*q^3)/exp(2*b*x) + (B^2*a^3*q^2)/exp(2*b*x) + (Q^2*a^2*b^3)/exp(2*q*x) + (Q^2*a^3*b^2)/exp(2*q*x) - (A^2*a*b*q^3)/exp(2*L*a) - (A^2*a*b^3*q)/exp(2*L*a) - (B^2*a*b*q^3)/exp(2*L*b) - (B^2*a^3*b*q)/exp(2*L*b) - (Q^2*a*b^3*q)/exp(2*L*q) - (Q^2*a^3*b*q)/exp(2*L*q) + (A^2*a*b*q^3)/exp(2*a*x) + (A^2*a*b^3*q)/exp(2*a*x) + (B^2*a*b*q^3)/exp(2*b*x) + (B^2*a^3*b*q)/exp(2*b*x) + (Q^2*a*b^3*q)/exp(2*q*x) + (Q^2*a^3*b*q)/exp(2*q*x) - (2*A^2*a*b^2*q^2)/exp(2*L*a) - (A^2*a^2*b*q^2)/exp(2*L*a) - (A^2*a^2*b^2*q)/exp(2*L*a) - (B^2*a*b^2*q^2)/exp(2*L*b) - (2*B^2*a^2*b*q^2)/exp(2*L*b) - (B^2*a^2*b^2*q)/exp(2*L*b) - (Q^2*a*b^2*q^2)/exp(2*L*q) - (Q^2*a^2*b*q^2)/exp(2*L*q) - (2*Q^2*a^2*b^2*q)/exp(2*L*q) + (2*A^2*a*b^2*q^2)/exp(2*a*x) + (A^2*a^2*b*q^2)/exp(2*a*x) + (A^2*a^2*b^2*q)/exp(2*a*x) + (B^2*a*b^2*q^2)/exp(2*b*x) + (2*B^2*a^2*b*q^2)/exp(2*b*x) + (B^2*a^2*b^2*q)/exp(2*b*x) + (Q^2*a*b^2*q^2)/exp(2*q*x) + (Q^2*a^2*b*q^2)/exp(2*q*x) + (2*Q^2*a^2*b^2*q)/exp(2*q*x) - (4*A*B*a*b^2*q^2)/exp(L*(a + b)) - (4*A*B*a^2*b*q^2)/exp(L*(a + b)) - (4*A*B*a^2*b^2*q)/exp(L*(a + b)) - (4*A*Q*a*b^2*q^2)/exp(L*(a + q)) - (4*A*Q*a^2*b*q^2)/exp(L*(a + q)) - (4*A*Q*a^2*b^2*q)/exp(L*(a + q)) - (4*B*Q*a*b^2*q^2)/exp(L*(b + q)) - (4*B*Q*a^2*b*q^2)/exp(L*(b + q)) - (4*B*Q*a^2*b^2*q)/exp(L*(b + q)) + (4*A*B*a*b^2*q^2)/exp(x*(a + b)) + (4*A*B*a^2*b*q^2)/exp(x*(a + b)) + (4*A*B*a^2*b^2*q)/exp(x*(a + b)) + (4*A*Q*a*b^2*q^2)/exp(x*(a + q)) + (4*A*Q*a^2*b*q^2)/exp(x*(a + q)) + (4*A*Q*a^2*b^2*q)/exp(x*(a + q)) + (4*B*Q*a*b^2*q^2)/exp(x*(b + q)) + (4*B*Q*a^2*b*q^2)/exp(x*(b + q)) + (4*B*Q*a^2*b^2*q)/exp(x*(b + q)) - (4*A*B*a*b*q^3)/exp(L*(a + b)) - (4*A*Q*a*b^3*q)/exp(L*(a + q)) - (4*B*Q*a^3*b*q)/exp(L*(b + q)) + (4*A*B*a*b*q^3)/exp(x*(a + b)) + (4*A*Q*a*b^3*q)/exp(x*(a + q)) + (4*B*Q*a^3*b*q)/exp(x*(b + q)))/(A^2*b^2*q^3 + A^2*b^3*q^2 + B^2*a^2*q^3 + B^2*a^3*q^2 + Q^2*a^2*b^3 + Q^2*a^3*b^2 + Q^2*a*b^2*q^2 + Q^2*a^2*b*q^2 + 2*Q^2*a^2*b^2*q - (A^2*b^2*q^3)/exp(2*L*a) - (A^2*b^3*q^2)/exp(2*L*a) - (B^2*a^2*q^3)/exp(2*L*b) - (B^2*a^3*q^2)/exp(2*L*b) - (Q^2*a^2*b^3)/exp(2*L*q) - (Q^2*a^3*b^2)/exp(2*L*q) + A^2*a*b*q^3 + A^2*a*b^3*q + B^2*a*b*q^3 + B^2*a^3*b*q + Q^2*a*b^3*q + Q^2*a^3*b*q + 2*A^2*a*b^2*q^2 + A^2*a^2*b*q^2 + A^2*a^2*b^2*q + B^2*a*b^2*q^2 + 2*B^2*a^2*b*q^2 + B^2*a^2*b^2*q - (A^2*a*b*q^3)/exp(2*L*a) - (A^2*a*b^3*q)/exp(2*L*a) - (B^2*a*b*q^3)/exp(2*L*b) - (B^2*a^3*b*q)/exp(2*L*b) - (Q^2*a*b^3*q)/exp(2*L*q) - (Q^2*a^3*b*q)/exp(2*L*q) - (2*A^2*a*b^2*q^2)/exp(2*L*a) - (A^2*a^2*b*q^2)/exp(2*L*a) - (A^2*a^2*b^2*q)/exp(2*L*a) - (B^2*a*b^2*q^2)/exp(2*L*b) - (2*B^2*a^2*b*q^2)/exp(2*L*b) - (B^2*a^2*b^2*q)/exp(2*L*b) + 4*A*B*a*b*q^3 - (Q^2*a*b^2*q^2)/exp(2*L*q) - (Q^2*a^2*b*q^2)/exp(2*L*q) - (2*Q^2*a^2*b^2*q)/exp(2*L*q) + 4*A*Q*a*b^3*q + 4*B*Q*a^3*b*q + 4*A*B*a*b^2*q^2 + 4*A*B*a^2*b*q^2 + 4*A*B*a^2*b^2*q + 4*A*Q*a*b^2*q^2 + 4*A*Q*a^2*b*q^2 + 4*A*Q*a^2*b^2*q + 4*B*Q*a*b^2*q^2 + 4*B*Q*a^2*b*q^2 + 4*B*Q*a^2*b^2*q - (4*A*B*a*b^2*q^2)/exp(L*(a + b)) - (4*A*B*a^2*b*q^2)/exp(L*(a + b)) - (4*A*B*a^2*b^2*q)/exp(L*(a + b)) - (4*A*Q*a*b^2*q^2)/exp(L*(a + q)) - (4*A*Q*a^2*b*q^2)/exp(L*(a + q)) - (4*A*Q*a^2*b^2*q)/exp(L*(a + q)) - (4*B*Q*a*b^2*q^2)/exp(L*(b + q)) - (4*B*Q*a^2*b*q^2)/exp(L*(b + q)) - (4*B*Q*a^2*b^2*q)/exp(L*(b + q)) - (4*A*B*a*b*q^3)/exp(L*(a + b)) - (4*A*Q*a*b^3*q)/exp(L*(a + q)) - (4*B*Q*a^3*b*q)/exp(L*(b + q)))  + x3*(L-x) )','problem','L');
        meddig=floor(length(mit)*1); % ezzel lehet lltani, hogy meddig nzze
        c = fit(t_smpl(1:length(mit))',mit',f,options,'problem',1);
        snr_est= -10.*log10(c.x3); if imag(snr_est)~=0, snr_est = Inf; end;
        A_est=[c.A c.B c.Q]./max(abs([c.A c.B c.Q]));
        R_est= Le * 1*k./[c.a c.b c.q];
    case 'x'
        x = ir2112(ir, fs, -0.01);
        A_est = x(1);
        R_est = 2*k/x(2);
        snr_est = -10*log10(abs(x(3)));
        c=NaN;
end;

