function [st1,st2,stl,stt] = st(yki,fs)

t0 = inicio(yki); if t0==1, t0=0; end;
t20 = t0 + 20/1000*fs;
t100 = t0 + 100/1000*fs;
t200 = t0 + 200/1000*fs;
t1000 = t0 + 1000/1000*fs;
tdir = t0 + 10/1000*fs;

sz1 = sum(yki(t20+1:t100).^2);
sz2 = sum(yki(t20+1:t200).^2);
sz3 = sum(yki(t100+1:t1000).^2);
sz4 = sum(yki(t20+1:t1000).^2);
nev = sum(yki(t0+1:tdir).^2);

st1 = 10*log10( sz1 / nev); % st1, st early
st2 = 10*log10( sz2 / nev); % st2
stl = 10*log10( sz3 / nev); % st late
stt = 10*log10( sz4 / nev); % st total