function [ x_ls, theta_ls, N_dummy ] = get_loudspeaker_layout( R_ls, x_center, type )
% This function returns the 3D positions and normals for the loudpseaker layout
% "Type", with the center xc and radius r0
if strcmp(  type,'2.0' )
    N_dummy = 3;
    azimuth = [-30 30 180 0 0]'*pi/180;
    elev_ls = [ zeros(length(azimuth)-N_dummy,1);0;pi/2;-pi/2];
    theta_ls = [ azimuth, pi/2-elev_ls, R_ls*ones(size(azimuth)) ];
    [x,y,z] = sph2cart(azimuth,elev_ls,R_ls);
    x_ls = [x y z];
elseif strcmp(  type,'Bformat' )
    N_dummy = 0;
    azimuth = [ -90 0 90 180  0 0]'*pi/180 + 45*pi/180;
    elev_ls = [ 0;0;0;0;pi/2;-pi/2];
    theta_ls = [ azimuth, pi/2-elev_ls, R_ls*ones(size(azimuth)) ];
    [x,y,z] = sph2cart(azimuth,elev_ls,R_ls);
    x_ls = [x y z];
elseif strcmp(  type,'5.1' )
    N_dummy = 2;
    azimuth = [30 -30 0 110 -110 0 0]'*pi/180;
    elev_ls = [ zeros(length(azimuth)-N_dummy,1);pi/2;-pi/2];
    theta_ls = [ azimuth, pi/2-elev_ls, R_ls*ones(size(azimuth)) ];
    [x,y,z] = sph2cart(azimuth,elev_ls,R_ls);
    x_ls = [x y z];
elseif strcmp(  type,'7.1' )
    N_dummy = 2;
    azimuth = [-30 0 30 100 -100 140 -140 0 0]'*pi/180;
    elev_ls = [ zeros(7, 1);pi/2;-pi/2 ];
    theta_ls = [ azimuth, pi/2-elev_ls, R_ls*ones(size(azimuth)) ];
    [x,y,z] = sph2cart(azimuth,elev_ls,R_ls);
    x_ls = [x y z];
elseif strcmp(  type,'22.2' )
    N_dummy = 1;
    azimuth = [ 55 30 0 -30 -55 90 -90 135 -135 180, 55 0 -55 90 0 -90 135 180 -135, 55 0 -55 0]'*pi/180;
    elev_ls = [ zeros(1,10)  30 30 30 30 90 30 30 30 30, -30 -30 -30 -90]'*pi/180;
    theta_ls = [ azimuth, pi/2-elev_ls, R_ls*ones(size(azimuth)) ];
    [x,y,z] = sph2cart(azimuth,elev_ls,R_ls);
    x_ls = [x y z];
elseif strcmp(  type,'circular' )
    azimuth = [(0:10:350) 0 0]'*pi/180;
    elev_ls = [ zeros(length(azimuth)-2,1);pi/2;-pi/2];
    theta_ls = [ azimuth, pi/2-elev_ls, R_ls*ones(size(azimuth)) ];
    [x,y,z] = sph2cart(azimuth,elev_ls,R_ls);
    N_dummy = 0;
    x_ls = [x y z];
elseif strcmp(  type,'ico' )   
    N_dummy = 0;
    ico = make_trunc_icosahedron;
    [azimuth,elev_ls,~] = cart2sph(ico.Centers(:,1),ico.Centers(:,2),ico.Centers(:,3));
    [x,y,z] = sph2cart(azimuth,elev_ls,R_ls);
    x_ls = [x y z];
    theta_ls = [ azimuth, pi/2-elev_ls, R_ls*ones(size(azimuth)) ];
elseif strcmp(  type,'Cheb_5100' )
    N_dummy = 0;
    fid = fopen('N100_M5100_Tetra.dat','r');
    formatspec = '%f';
    A = fscanf(fid,formatspec);
    x_ls = reshape(A(3:end),3,length(A(3:end))/3)';
    [azimuth,elev_ls,~] = cart2sph(x_ls(:,1),x_ls(:,2),x_ls(:,3));
    [x,y,z] = sph2cart(azimuth,elev_ls,R_ls);
    x_ls = [x y z];
    theta_ls = [ azimuth, pi/2-elev_ls, R_ls*ones(size(azimuth)) ];
    fclose(fid);
elseif strcmp(  type,'Cheb_5200' )
    N_dummy = 0;
    fid = fopen('Design_5200_100_random.dat','r');
    formatspec = '%f';
    A = fscanf(fid,formatspec);
    Theta = reshape(A,2,length(A)/2)';
    x_ls = R_ls* [ sin(Theta(:,2)).*cos(Theta(:,1)) sin(Theta(:,1)).*sin(Theta(:,2)) cos(Theta(:,2))];
    [azimuth,elev_ls,~] = cart2sph(x_ls(:,1),x_ls(:,2),x_ls(:,3));
    theta_ls = [ azimuth, pi/2-elev_ls, R_ls*ones(size(azimuth)) ];
    fclose(fid);
elseif strcmp(  type,'Cheb_21k' )
    fid = fopen('Design_21000_200_random.dat','r');
    formatspec = '%f';
    A = fscanf(fid,formatspec);
    Theta = reshape(A,2,length(A)/2)';
    x_ls = R_ls* [ sin(Theta(:,2)).*cos(Theta(:,1)) sin(Theta(:,1)).*sin(Theta(:,2)) cos(Theta(:,2))];
    [azimuth,elev_ls,~] = cart2sph(x_ls(:,1),x_ls(:,2),x_ls(:,3));
    theta_ls = [ azimuth, pi/2-elev_ls, R_ls*ones(size(azimuth)) ];
    fclose(fid);
end
x_ls = bsxfun(@plus, x_ls, x_center );
end

