function [LeqA, LeqA8, LeqC, LeqC8, Leq, Leq8, Ba, Aa, Bc, Ac, peak, peakA, peakC]=Leq_all_calc(y, fs, cf, Ba, Aa, Bc, Ac)
% % This program calculates the A-weighted, C-weighted and Linear weighted
% % sound levels, 8 hour equivalent sound levels, and peak levels, for the 
% % input sound pressure time record y.  
% % 
% Example='';
% y=rand(1,100000);     % Pa Sound Pressure time record
% fs=50000;             % Hz sampling rate for sound pressure data
% cf=1;                 % 1 calibration factor default value is 1
% Ba=[];                % input array of A-weighting filter coefficients 
% Aa=[];                % input array of A-weighting filter coefficients 
% Bc=[];                % input array of C-weighting filter coefficients 
% Ac=[];                % input array of C-weighting filter coefficients 
% 
%  [LeqA, LeqA8, LeqC, LeqC8, Leq, Leq8, Ba, Aa, Bc, Ac, peak, peakA, peakC]=Leq_all_calc(y, fs, cf, Ba, Aa, Bc, Ac);
%
% % 
% % Output Variables
% % 
% % LeqA is the A-weighted sound pressure level dBA
% % LeqA8 is the 8-hour equivalent A-weighted sound pressure level dBA
% % LeqC is the C-weighted sound pressure level dBC
% % LeqC8 is the 8-hour equivalent C-weighted sound pressure level dBC
% % Leq is the Linear-weighted sound pressure level dB
% % Leq8 is the 8-hour equivalent Linear-weighted sound pressure level dB
% % Ba is an array of A-weighting filter coefficients 
% % Aa is an array of A-weighting filter coefficients 
% % Bc is an array of C-weighting filter coefficients 
% % Ac is an array of C-weighting filter coefficients 
% % peak is the un-weighted peak level dB
% % peakA is the A-weighted peak level dBA
% % peakC is the C-weighted peak level dBC
% % 
% % 
% % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %
% % Program Written by Edward L. Zechmann 
% %     date    uncertain   2007
% % 
% % modified 19 December    2007    added comments and an example
% % 
% % modified 13 February    2007    updated comments 
% %                     
% %                     
% %  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % 
% % Please feel free to modify this code.
% % 


% Reference level for dB scale. 
Pref = 20e-6;                

[m1 n1]=size(y);
flag1=0;

if m1 > n1
    flag1=1;
    y=y';
    [m1, n1]=size(y);
end

if nargin < 2
    fs=50000;
end

if nargin < 3
    cf=1;
end

y = cf.*y;

if nargin < 4
    [yA, Ba, Aa]=Aweight_time_filter(y, fs);  
else
    [yA, Ba, Aa]=Aweight_time_filter(y, fs, Ba, Aa);
end

if nargin < 7
    [yC, Bc, Ac]=Cweight_time_filter(y, fs);  
else
    [yC, Bc, Ac]=Cweight_time_filter(y, fs, Bc, Ac);
end

n1=length(y);

Leq   = 10 * log10(  (sqrt(sum(y'.^2))./sqrt(n1)./Pref).^2  );
Leq8  = 10*log10(n1./fs./(8*3600))*ones(size(Leq))+Leq;

LeqA  = 10 * log10(  (sqrt(sum(yA'.^2))./sqrt(n1)./Pref).^2  );
LeqA8 = 10*log10(n1./fs./(8*3600))*ones(size(LeqA))+LeqA;

LeqC  = 10 * log10(  (sqrt(sum(yC'.^2))./sqrt(n1)./Pref).^2  );
LeqC8 = 10*log10(n1./fs./(8*3600))*ones(size(LeqC))+LeqC;

[abs_peak  y_ix ]=max(abs( y ));
[abs_peakA yA_ix]=max(abs( yA ));
[abs_peakC yC_ix]=max(abs( yC ));

peak =y(  y_ix );
peakA=yA( yA_ix );
peakC=yC( yC_ix );
