classdef radial_filter_bank < handle
    %RADIAL_FILTERS Summary of this class goes here
    %   Detailed explanation goes here

    properties
        Nhoa
        filter_bank
    end

    methods
        function obj = radial_filter_bank(Nhoa,h_filters,Nt)
            obj.Nhoa = Nhoa;
            for n = 0 : Nhoa
                for m = -n:n
                    l = n^2+n+m+1;
                    obj.filter_bank{l} = OLS_convolver(h_filters(:,n+1),Nt);
                end
            end
        end

        function filteredSignal = filter(obj,input)
            filteredSignal = zeros(size(input));
            for n = 0 : obj.Nhoa
                for m = -n:n
                    l = n^2+n+m+1;
                    filteredSignal(:,l) = obj.filter_bank{l}.convolve( input(:,l) );
                end
            end
        end
    end
end

