classdef binauralRenderer < handle
    %RADIAL_FILTERS Summary of this class goes here
    %   Detailed explanation goes here

    properties
        binaural_filter
    end

    methods
        function obj = binauralRenderer(hrtf_in, Nt)
            for n = 1 : size(hrtf_in,1)
                obj.binaural_filter{n}  = OLS_convolver(squeeze(hrtf_in(n,:,:))', Nt,'spectrum');
            end
        end

        function filteredSignal = render(obj,input)
            output = zeros(size(input,1)*2,1);
            for n = 1 : size(input,2)
                [out, ix] = obj.binaural_filter{n}.convolve(input(:,n));
                output = output + out;
            end

            filteredSignal = ifft(output);
            filteredSignal = filteredSignal(ix(1):ix(end));
            filteredSignal = [real(filteredSignal), imag(filteredSignal)];
        end
    end
end

