function degree = dunavant_degree ( rule )

%*****************************************************************************80
%
%% dunavant_degree() returns the degree of a Dunavant rule for the triangle.
%
%  Licensing:
%
%    This code is distributed under the GNU LGPL license.
%
%  Modified:
%
%    11 December 2006
%
%  Author:
%
%    John Burkardt
%
%  Reference:
%
%    David Dunavant,
%    High Degree Efficient Symmetrical Gaussian Quadrature Rules
%    for the Triangle, 
%    International Journal for Numerical Methods in Engineering,
%    Volume 21, 1985, pages 1129-1148.
%
%    James Lyness, Dennis Jespersen,
%    Moderate Degree Symmetric Quadrature Rules for the Triangle,
%    Journal of the Institute of Mathematics and its Applications,
%    Volume 15, Number 1, February 1975, pages 19-32.
%
%  Input:
%
%    integer RULE, the index of the rule.
%
%  Output:
%
%    integer DEGREE, the polynomial degree of exactness of
%    the rule.
%
  if ( 1 <= rule && rule <= 20 )
    degree = rule;
  else

    degree = -1;
    fprintf ( 1, '\n' );
    fprintf ( 1, 'DUNAVANT_DEGREE - Fatal error!\n' );
    fprintf ( 1, '  Illegal RULE = %d\n', rule );
    error ( 'DUNAVANT_DEGREE - Fatal error!' )

  end

  return
end
