function fv=QuadRhombDodecMesh
% Get a quad mesh of a rhombic dodecahedron whose vertices lie on the 
% surface of a zero-centered unit sphere.
%
%   - fv    : structure with fields 'faces' and 'vertices' representing 
%             quad mesh of a rhombic dodecahedron
%
% AUTHOR: Anton Semechko (a.semechko@gmail.com)
%


a=sqrt(2); 
b=sqrt(2)/2;

X=[ 0,  0,  a;...
    0,  0, -a;...
    a,  0,  0;...
   -a,  0,  0;...
    0,  a,  0;...
    0, -a,  0;...
    b,  b,  b;...
    b,  b, -b;...
    b, -b,  b;...
    b, -b, -b;...
   -b,  b,  b;...
   -b,  b, -b;...
   -b, -b,  b;...
   -b, -b, -b];

F=[  7,  1,  9,  3;...
     7,  3,  8,  5;...
     7,  5, 11,  1;...
    10,  2,  8,  3;...
    10,  3,  9,  6;...
    10,  6, 14,  2;...
    12,  2, 14,  4;...
    12,  4, 11,  5;...
    12,  5,  8,  2;...
    13,  1, 11,  4;...
    13,  4, 14,  6;...
    13,  6,  9,  1];

fv.faces=F;
fv.vertices=X/sqrt(3);
